/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import java.util.Map;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyClass;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.__builtin__;
import org.python.core.codecs;
import org.python.core.exceptions;
import org.python.core.imp;
import org.python.modules.PyIOFile;
import org.python.modules.PyIOFileFactory;
import org.python.modules.cStringIO;
import org.python.util.Generic;

public class cPickle
implements ClassDictInit {
    public static String __doc__ = "Java implementation and optimization of the Python pickle module\n\n$Id: cPickle.java 7163 2010-10-22 01:40:30Z zyasoft $\n";
    public static String __version__ = "1.30";
    public static final String format_version = "2.0";
    public static final String[] compatible_formats = new String[]{"1.0", "1.1", "1.2", "1.3", "2.0"};
    public static final int HIGHEST_PROTOCOL = 2;
    public static String[] __depends__ = new String[]{"copy_reg"};
    public static PyObject PickleError;
    public static PyObject PicklingError;
    public static PyObject UnpickleableError;
    public static PyObject UnpicklingError;
    public static PyObject BadPickleGet;
    static final char MARK = '(';
    static final char STOP = '.';
    static final char POP = '0';
    static final char POP_MARK = '1';
    static final char DUP = '2';
    static final char FLOAT = 'F';
    static final char INT = 'I';
    static final char BININT = 'J';
    static final char BININT1 = 'K';
    static final char LONG = 'L';
    static final char BININT2 = 'M';
    static final char NONE = 'N';
    static final char PERSID = 'P';
    static final char BINPERSID = 'Q';
    static final char REDUCE = 'R';
    static final char STRING = 'S';
    static final char BINSTRING = 'T';
    static final char SHORT_BINSTRING = 'U';
    static final char UNICODE = 'V';
    static final char BINUNICODE = 'X';
    static final char APPEND = 'a';
    static final char BUILD = 'b';
    static final char GLOBAL = 'c';
    static final char DICT = 'd';
    static final char EMPTY_DICT = '}';
    static final char APPENDS = 'e';
    static final char GET = 'g';
    static final char BINGET = 'h';
    static final char INST = 'i';
    static final char LONG_BINGET = 'j';
    static final char LIST = 'l';
    static final char EMPTY_LIST = ']';
    static final char OBJ = 'o';
    static final char PUT = 'p';
    static final char BINPUT = 'q';
    static final char LONG_BINPUT = 'r';
    static final char SETITEM = 's';
    static final char TUPLE = 't';
    static final char EMPTY_TUPLE = ')';
    static final char SETITEMS = 'u';
    static final char BINFLOAT = 'G';
    static final char PROTO = '\u0080';
    static final char NEWOBJ = '\u0081';
    static final char EXT1 = '\u0082';
    static final char EXT2 = '\u0083';
    static final char EXT4 = '\u0084';
    static final char TUPLE1 = '\u0085';
    static final char TUPLE2 = '\u0086';
    static final char TUPLE3 = '\u0087';
    static final char NEWTRUE = '\u0088';
    static final char NEWFALSE = '\u0089';
    static final char LONG1 = '\u008a';
    static final char LONG4 = '\u008b';
    private static PyDictionary dispatch_table;
    private static PyDictionary extension_registry;
    private static PyDictionary inverted_registry;
    private static PyType BuiltinCallableType;
    private static PyType ReflectedFunctionType;
    private static PyType ClassType;
    private static PyType TypeType;
    private static PyType DictionaryType;
    private static PyType StringMapType;
    private static PyType FloatType;
    private static PyType FunctionType;
    private static PyType InstanceType;
    private static PyType IntType;
    private static PyType ListType;
    private static PyType LongType;
    private static PyType NoneType;
    private static PyType StringType;
    private static PyType UnicodeType;
    private static PyType TupleType;
    private static PyType FileType;
    private static PyType BoolType;
    private static PyObject dict;
    private static final int BATCHSIZE = 1024;
    private static Map<PyObject, PyObject> classmap;

    public static void classDictInit(PyObject pyObject) {
        dict = pyObject;
        imp.importName("__builtin__", true);
        PyModule pyModule = (PyModule)cPickle.importModule("copy_reg");
        dispatch_table = (PyDictionary)pyModule.__getattr__("dispatch_table");
        extension_registry = (PyDictionary)pyModule.__getattr__("_extension_registry");
        inverted_registry = (PyDictionary)pyModule.__getattr__("_inverted_registry");
        PickleError = Py.makeClass("PickleError", Py.Exception, cPickle._PickleError());
        PicklingError = Py.makeClass("PicklingError", PickleError, cPickle.exceptionNamespace());
        UnpickleableError = Py.makeClass("UnpickleableError", PicklingError, cPickle._UnpickleableError());
        UnpicklingError = Py.makeClass("UnpicklingError", PickleError, cPickle.exceptionNamespace());
        BadPickleGet = Py.makeClass("BadPickleGet", UnpicklingError, cPickle.exceptionNamespace());
    }

    public static PyObject exceptionNamespace() {
        PyStringMap pyStringMap = new PyStringMap();
        ((PyObject)pyStringMap).__setitem__("__module__", (PyObject)new PyString("cPickle"));
        return pyStringMap;
    }

    public static PyObject _PickleError() {
        dict = cPickle.exceptionNamespace();
        dict.__setitem__("__str__", cPickle.getJavaFunc("__str__", "_PickleError__str__"));
        return dict;
    }

    public static PyString _PickleError__str__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyObject pyObject2 = pyObject.__getattr__("args");
        if (pyObject2.__len__() > 0 && pyObject2.__getitem__(0).__len__() > 0) {
            return pyObject2.__getitem__(0).__str__();
        }
        return new PyString("(what)");
    }

    public static PyObject _UnpickleableError() {
        dict = cPickle.exceptionNamespace();
        dict.__setitem__("__str__", cPickle.getJavaFunc("__str__", "_UnpickleableError__str__"));
        return dict;
    }

    public static PyString _UnpickleableError__str__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyObject pyObject2 = pyObject.__getattr__("args");
        PyObject pyObject3 = pyObject2.__len__() > 0 ? pyObject2.__getitem__(0) : new PyString("(what)");
        return new PyString("Cannot pickle %s objects").__mod__(pyObject3).__str__();
    }

    public static Pickler Pickler(PyObject pyObject) {
        return new Pickler(pyObject, 0);
    }

    public static Pickler Pickler(PyObject pyObject, int n) {
        return new Pickler(pyObject, n);
    }

    public static Unpickler Unpickler(PyObject pyObject) {
        return new Unpickler(pyObject);
    }

    public static void dump(PyObject pyObject, PyObject pyObject2) {
        cPickle.dump(pyObject, pyObject2, 0);
    }

    public static void dump(PyObject pyObject, PyObject pyObject2, int n) {
        new Pickler(pyObject2, n).dump(pyObject);
    }

    public static PyString dumps(PyObject pyObject) {
        return cPickle.dumps(pyObject, 0);
    }

    public static PyString dumps(PyObject pyObject, int n) {
        cStringIO.StringIO stringIO = cStringIO.StringIO();
        cPickle.dump(pyObject, stringIO, n);
        return stringIO.getvalue();
    }

    public static Object load(PyObject pyObject) {
        return new Unpickler(pyObject).load();
    }

    public static Object loads(PyObject pyObject) {
        cStringIO.StringIO stringIO = cStringIO.StringIO(pyObject.toString());
        return new Unpickler(stringIO).load();
    }

    private static final PyObject whichmodule(PyObject pyObject, PyObject pyObject2) {
        PyObject pyObject3 = classmap.get(pyObject);
        if (pyObject3 != null) {
            return pyObject3;
        }
        pyObject3 = new PyString("__main__");
        PyObject pyObject4 = imp.importName("sys", true);
        PyObject pyObject5 = pyObject4.__findattr__("modules");
        PyObject pyObject6 = pyObject5.invoke("keys");
        int n = pyObject6.__len__();
        for (int i = 0; i < n; ++i) {
            PyObject pyObject7 = pyObject6.__finditem__(i);
            PyObject pyObject8 = pyObject5.__finditem__(pyObject7);
            if (pyObject7.equals("__main__") || pyObject8.__findattr__(pyObject2.toString().intern()) != pyObject) continue;
            pyObject3 = pyObject7;
            break;
        }
        classmap.put(pyObject, pyObject3);
        return pyObject3;
    }

    private static PyObject importModule(String string) {
        PyTuple pyTuple = new PyTuple(Py.newString("__doc__"));
        return __builtin__.__import__(string, Py.None, Py.None, pyTuple);
    }

    private static PyObject getJavaFunc(String string, String string2) {
        return exceptions.bindStaticJavaMethod(string, cPickle.class, string2);
    }

    static {
        BuiltinCallableType = PyType.fromClass(PyBuiltinCallable.class);
        ReflectedFunctionType = PyType.fromClass(PyReflectedFunction.class);
        ClassType = PyType.fromClass(PyClass.class);
        TypeType = PyType.fromClass(PyType.class);
        DictionaryType = PyType.fromClass(PyDictionary.class);
        StringMapType = PyType.fromClass(PyStringMap.class);
        FloatType = PyType.fromClass(PyFloat.class);
        FunctionType = PyType.fromClass(PyFunction.class);
        InstanceType = PyType.fromClass(PyInstance.class);
        IntType = PyType.fromClass(PyInteger.class);
        ListType = PyType.fromClass(PyList.class);
        LongType = PyType.fromClass(PyLong.class);
        NoneType = PyType.fromClass(PyNone.class);
        StringType = PyType.fromClass(PyString.class);
        UnicodeType = PyType.fromClass(PyUnicode.class);
        TupleType = PyType.fromClass(PyTuple.class);
        FileType = PyType.fromClass(PyFile.class);
        BoolType = PyType.fromClass(PyBoolean.class);
        classmap = Generic.map();
    }

    private static class PickleMemo {
        private final int[] primes = new int[]{13, 61, 251, 1021, 4093, 5987, 9551, 15683, 19609, 31397, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD, 33554393, 0x3FFFFFB, 134217689, 0xFFFFFC7, 0x1FFFFFFD, 0x3FFFFFDD};
        private transient int[] keys = null;
        private transient int[] position;
        private transient Object[] values = null;
        private int size;
        private transient int filled;
        private transient int prime = 0;

        public PickleMemo(int n) {
            this.resize(n);
        }

        public PickleMemo() {
            this(4);
        }

        public int size() {
            return this.size;
        }

        private int findIndex(int n, Object object) {
            int[] nArray = this.keys;
            int n2 = nArray.length;
            int n3 = (n & Integer.MAX_VALUE) % n2;
            int n4 = n2 / 5;
            int n5;
            while ((n5 = nArray[n3]) != n || object != this.values[n3]) {
                if (this.values[n3] == null) {
                    return -1;
                }
                n3 = (n3 + n4) % n2;
            }
            return n3;
        }

        public int findPosition(int n, Object object) {
            int n2 = this.findIndex(n, object);
            if (n2 < 0) {
                return -1;
            }
            return this.position[n2];
        }

        public Object findValue(int n, Object object) {
            int n2 = this.findIndex(n, object);
            if (n2 < 0) {
                return null;
            }
            return this.values[n2];
        }

        private final void insertkey(int n, int n2, Object object) {
            int[] nArray = this.keys;
            int n3 = nArray.length;
            int n4 = (n & Integer.MAX_VALUE) % n3;
            int n5 = n3 / 5;
            while (true) {
                int n6 = nArray[n4];
                if (this.values[n4] == null) {
                    nArray[n4] = n;
                    this.position[n4] = n2;
                    this.values[n4] = object;
                    ++this.filled;
                    ++this.size;
                    break;
                }
                if (n6 == n && this.values[n4] == object) {
                    this.position[n4] = n2;
                    break;
                }
                n4 = (n4 + n5) % n3;
            }
        }

        private final void resize(int n) {
            int n2;
            for (n2 = this.prime; n2 < this.primes.length && this.primes[n2] < n; ++n2) {
            }
            if (this.primes[n2] < n) {
                throw Py.ValueError("can't make hashtable of size: " + n);
            }
            n = this.primes[n2];
            this.prime = n2;
            int[] nArray = this.keys;
            int[] nArray2 = this.position;
            Object[] objectArray = this.values;
            this.keys = new int[n];
            this.position = new int[n];
            this.values = new Object[n];
            this.size = 0;
            this.filled = 0;
            if (objectArray != null) {
                int n3 = objectArray.length;
                for (int i = 0; i < n3; ++i) {
                    Object object = objectArray[i];
                    if (object == null) continue;
                    this.insertkey(nArray[i], nArray2[i], object);
                }
            }
        }

        public void put(int n, int n2, Object object) {
            if (2 * this.filled > this.keys.length) {
                this.resize(this.keys.length + 1);
            }
            this.insertkey(n, n2, object);
        }
    }

    public static class Pickler {
        private PyIOFile file;
        private int protocol;
        public boolean fast = false;
        private PickleMemo memo = new PickleMemo();
        public PyObject persistent_id = null;
        public PyObject inst_persistent_id = null;

        public Pickler(PyObject pyObject, int n) {
            this.file = PyIOFileFactory.createIOFile(pyObject);
            this.protocol = n;
        }

        public void dump(PyObject pyObject) {
            if (this.protocol >= 2) {
                this.file.write('\u0080');
                this.file.write((char)this.protocol);
            }
            this.save(pyObject);
            this.file.write('.');
            this.file.flush();
        }

        private static final int get_id(PyObject pyObject) {
            return System.identityHashCode(pyObject);
        }

        private void put(int n) {
            if (this.protocol > 0) {
                if (n < 256) {
                    this.file.write('q');
                    this.file.write((char)n);
                    return;
                }
                this.file.write('r');
                this.file.write((char)(n & 0xFF));
                this.file.write((char)(n >>> 8 & 0xFF));
                this.file.write((char)(n >>> 16 & 0xFF));
                this.file.write((char)(n >>> 24 & 0xFF));
                return;
            }
            this.file.write('p');
            this.file.write(String.valueOf(n));
            this.file.write("\n");
        }

        private void get(int n) {
            if (this.protocol > 0) {
                if (n < 256) {
                    this.file.write('h');
                    this.file.write((char)n);
                    return;
                }
                this.file.write('j');
                this.file.write((char)(n & 0xFF));
                this.file.write((char)(n >>> 8 & 0xFF));
                this.file.write((char)(n >>> 16 & 0xFF));
                this.file.write((char)(n >>> 24 & 0xFF));
                return;
            }
            this.file.write('g');
            this.file.write(String.valueOf(n));
            this.file.write("\n");
        }

        private void save(PyObject pyObject) {
            this.save(pyObject, false);
        }

        private void save(PyObject pyObject, boolean bl) {
            PyObject pyObject2;
            if (!bl && this.persistent_id != null && this.save_pers(pyObject, this.persistent_id)) {
                return;
            }
            int n = Pickler.get_id(pyObject);
            PyType pyType = pyObject.getType();
            if (pyType == TupleType && pyObject.__len__() == 0) {
                if (this.protocol > 0) {
                    this.save_empty_tuple(pyObject);
                } else {
                    this.save_tuple(pyObject);
                }
                return;
            }
            int n2 = this.getMemoPosition(n, pyObject);
            if (n2 >= 0) {
                this.get(n2);
                return;
            }
            if (this.save_type(pyObject, pyType)) {
                return;
            }
            if (!bl && this.inst_persistent_id != null && this.save_pers(pyObject, this.inst_persistent_id)) {
                return;
            }
            if (Py.isSubClass(pyType, PyType.TYPE)) {
                this.save_global(pyObject);
                return;
            }
            PyObject pyObject3 = null;
            PyObject pyObject4 = dispatch_table.__finditem__(pyType);
            if (pyObject4 == null) {
                pyObject4 = pyObject.__findattr__("__reduce_ex__");
                if (pyObject4 != null) {
                    pyObject3 = pyObject4.__call__(Py.newInteger(this.protocol));
                } else {
                    pyObject4 = pyObject.__findattr__("__reduce__");
                    if (pyObject4 == null) {
                        throw new PyException(UnpickleableError, pyObject);
                    }
                    pyObject3 = pyObject4.__call__();
                }
            } else {
                pyObject3 = pyObject4.__call__(pyObject);
            }
            if (pyObject3 instanceof PyString) {
                this.save_global(pyObject, pyObject3);
                return;
            }
            if (!(pyObject3 instanceof PyTuple)) {
                throw new PyException(PicklingError, "Value returned by " + pyObject4.__repr__() + " must be a tuple");
            }
            int n3 = pyObject3.__len__();
            if (n3 < 2 || n3 > 5) {
                throw new PyException(PicklingError, "tuple returned by " + pyObject4.__repr__() + " must contain two to five elements");
            }
            PyObject pyObject5 = pyObject3.__finditem__(0);
            PyObject pyObject6 = pyObject3.__finditem__(1);
            PyObject pyObject7 = n3 > 2 ? pyObject3.__finditem__(2) : Py.None;
            PyObject pyObject8 = n3 > 3 ? pyObject3.__finditem__(3) : Py.None;
            PyObject pyObject9 = pyObject2 = n3 > 4 ? pyObject3.__finditem__(4) : Py.None;
            if (!(pyObject6 instanceof PyTuple) && pyObject6 != Py.None) {
                throw new PyException(PicklingError, "Second element of tupe returned by " + pyObject4.__repr__() + " must be a tuple");
            }
            this.save_reduce(pyObject5, pyObject6, pyObject7, pyObject8, pyObject2, pyObject);
        }

        private final boolean save_pers(PyObject pyObject, PyObject pyObject2) {
            PyObject pyObject3 = pyObject2.__call__(pyObject);
            if (pyObject3 == Py.None) {
                return false;
            }
            if (this.protocol == 0) {
                if (!Py.isInstance(pyObject3, PyString.TYPE)) {
                    throw new PyException(PicklingError, "persistent id must be string");
                }
                this.file.write('P');
                this.file.write(pyObject3.toString());
                this.file.write("\n");
            } else {
                this.save(pyObject3, true);
                this.file.write('Q');
            }
            return true;
        }

        private final void save_reduce(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4, PyObject pyObject5, PyObject pyObject6) {
            PyObject pyObject7 = pyObject.__findattr__("__name__");
            if (this.protocol >= 2 && pyObject7 != null && "__newobj__".equals(pyObject7.toString())) {
                PyObject pyObject8 = pyObject2.__finditem__(0);
                if (pyObject8.__findattr__("__new__") == null) {
                    throw new PyException(PicklingError, "args[0] from __newobj__ args has no __new__");
                }
                this.save(pyObject8);
                this.save(pyObject2.__getslice__(Py.One, Py.None));
                this.file.write('\u0081');
            } else {
                this.save(pyObject);
                this.save(pyObject2);
                this.file.write('R');
            }
            this.put(this.putMemo(Pickler.get_id(pyObject6), pyObject6));
            if (pyObject4 != Py.None) {
                this.batch_appends(pyObject4);
            }
            if (pyObject5 != Py.None) {
                this.batch_setitems(pyObject5);
            }
            if (pyObject3 != Py.None) {
                this.save(pyObject3);
                this.file.write('b');
            }
        }

        private final boolean save_type(PyObject pyObject, PyType pyType) {
            if (pyType == NoneType) {
                this.save_none(pyObject);
            } else if (pyType == StringType) {
                this.save_string(pyObject);
            } else if (pyType == UnicodeType) {
                this.save_unicode(pyObject);
            } else if (pyType == IntType) {
                this.save_int(pyObject);
            } else if (pyType == LongType) {
                this.save_long(pyObject);
            } else if (pyType == FloatType) {
                this.save_float(pyObject);
            } else if (pyType == TupleType) {
                this.save_tuple(pyObject);
            } else if (pyType == ListType) {
                this.save_list(pyObject);
            } else if (pyType == DictionaryType || pyType == StringMapType) {
                this.save_dict(pyObject);
            } else if (pyType == InstanceType) {
                this.save_inst((PyInstance)pyObject);
            } else if (pyType == ClassType) {
                this.save_global(pyObject);
            } else if (pyType == TypeType) {
                this.save_global(pyObject);
            } else if (pyType == FunctionType) {
                this.save_global(pyObject);
            } else if (pyType == BuiltinCallableType) {
                this.save_global(pyObject);
            } else if (pyType == ReflectedFunctionType) {
                this.save_global(pyObject);
            } else if (pyType == BoolType) {
                this.save_bool(pyObject);
            } else {
                return false;
            }
            return true;
        }

        private final void save_none(PyObject pyObject) {
            this.file.write('N');
        }

        private final void save_int(PyObject pyObject) {
            if (this.protocol > 0) {
                int n = ((PyInteger)pyObject).getValue();
                char c = (char)(n & 0xFF);
                char c2 = (char)(n >>> 8 & 0xFF);
                char c3 = (char)(n >>> 16 & 0xFF);
                char c4 = (char)(n >>> 24 & 0xFF);
                if (c3 == '\u0000' && c4 == '\u0000') {
                    if (c2 == '\u0000') {
                        this.file.write('K');
                        this.file.write(c);
                        return;
                    }
                    this.file.write('M');
                    this.file.write(c);
                    this.file.write(c2);
                    return;
                }
                this.file.write('J');
                this.file.write(c);
                this.file.write(c2);
                this.file.write(c3);
                this.file.write(c4);
            } else {
                this.file.write('I');
                this.file.write(pyObject.toString());
                this.file.write("\n");
            }
        }

        private void save_bool(PyObject pyObject) {
            int n = ((PyBoolean)pyObject).getValue();
            if (this.protocol >= 2) {
                this.file.write(n != 0 ? (char)'\u0088' : '\u0089');
            } else {
                this.file.write('I');
                this.file.write(n != 0 ? "01" : "00");
                this.file.write("\n");
            }
        }

        private void save_long(PyObject pyObject) {
            if (this.protocol >= 2) {
                BigInteger bigInteger = ((PyLong)pyObject).getValue();
                if (bigInteger.compareTo(BigInteger.ZERO) == 0) {
                    this.file.write('\u008a');
                    this.file.write('\u0000');
                    return;
                }
                byte[] byArray = bigInteger.toByteArray();
                int n = byArray.length;
                if (n < 256) {
                    this.file.write('\u008a');
                    this.file.write((char)n);
                } else {
                    this.file.write('\u008b');
                    this.writeInt4(n);
                }
                for (int i = n - 1; i >= 0; --i) {
                    int n2 = byArray[i] & 0xFF;
                    this.file.write((char)n2);
                }
            } else {
                this.file.write('L');
                this.file.write(pyObject.toString());
                this.file.write("\n");
            }
        }

        private void writeInt4(int n) {
            char c = (char)(n & 0xFF);
            char c2 = (char)(n >>> 8 & 0xFF);
            char c3 = (char)(n >>> 16 & 0xFF);
            char c4 = (char)(n >>> 24 & 0xFF);
            this.file.write(c);
            this.file.write(c2);
            this.file.write(c3);
            this.file.write(c4);
        }

        private final void save_float(PyObject pyObject) {
            if (this.protocol > 0) {
                this.file.write('G');
                double d = ((PyFloat)pyObject).getValue();
                long l = Double.doubleToLongBits(d);
                this.file.write((char)(l >>> 56 & 0xFFL));
                this.file.write((char)(l >>> 48 & 0xFFL));
                this.file.write((char)(l >>> 40 & 0xFFL));
                this.file.write((char)(l >>> 32 & 0xFFL));
                this.file.write((char)(l >>> 24 & 0xFFL));
                this.file.write((char)(l >>> 16 & 0xFFL));
                this.file.write((char)(l >>> 8 & 0xFFL));
                this.file.write((char)(l >>> 0 & 0xFFL));
            } else {
                this.file.write('F');
                this.file.write(pyObject.toString());
                this.file.write("\n");
            }
        }

        private final void save_string(PyObject pyObject) {
            String string = pyObject.toString();
            if (this.protocol > 0) {
                int n = string.length();
                if (n < 256) {
                    this.file.write('U');
                    this.file.write((char)n);
                } else {
                    this.file.write('T');
                    this.file.write((char)(n & 0xFF));
                    this.file.write((char)(n >>> 8 & 0xFF));
                    this.file.write((char)(n >>> 16 & 0xFF));
                    this.file.write((char)(n >>> 24 & 0xFF));
                }
                this.file.write(string);
            } else {
                this.file.write('S');
                this.file.write(pyObject.__repr__().toString());
                this.file.write("\n");
            }
            this.put(this.putMemo(Pickler.get_id(pyObject), pyObject));
        }

        private void save_unicode(PyObject pyObject) {
            if (this.protocol > 0) {
                String string = codecs.PyUnicode_EncodeUTF8(pyObject.toString(), "struct");
                this.file.write('X');
                this.writeInt4(string.length());
                this.file.write(string);
            } else {
                this.file.write('V');
                this.file.write(codecs.PyUnicode_EncodeRawUnicodeEscape(pyObject.toString(), "strict", true));
                this.file.write("\n");
            }
            this.put(this.putMemo(Pickler.get_id(pyObject), pyObject));
        }

        private void save_tuple(PyObject pyObject) {
            int n;
            int n2 = Pickler.get_id(pyObject);
            int n3 = pyObject.__len__();
            if (n3 > 0 && n3 <= 3 && this.protocol >= 2) {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    this.save(pyObject.__finditem__(n4));
                }
                n4 = this.getMemoPosition(n2, pyObject);
                if (n4 >= 0) {
                    for (int i = 0; i < n3; ++i) {
                        this.file.write('0');
                    }
                    this.get(n4);
                } else {
                    char c = (char)(133 + n3 - 1);
                    this.file.write(c);
                    this.put(this.putMemo(n2, pyObject));
                }
                return;
            }
            this.file.write('(');
            for (n = 0; n < n3; ++n) {
                this.save(pyObject.__finditem__(n));
            }
            if (n3 > 0 && (n = this.getMemoPosition(n2, pyObject)) >= 0) {
                if (this.protocol > 0) {
                    this.file.write('1');
                    this.get(n);
                    return;
                }
                for (int i = 0; i < n3 + 1; ++i) {
                    this.file.write('0');
                }
                this.get(n);
                return;
            }
            this.file.write('t');
            this.put(this.putMemo(n2, pyObject));
        }

        private final void save_empty_tuple(PyObject pyObject) {
            this.file.write(')');
        }

        private void save_list(PyObject pyObject) {
            if (this.protocol > 0) {
                this.file.write(']');
            } else {
                this.file.write('(');
                this.file.write('l');
            }
            this.put(this.putMemo(Pickler.get_id(pyObject), pyObject));
            this.batch_appends(pyObject);
        }

        private void batch_appends(PyObject pyObject) {
            int n = 0;
            for (PyObject pyObject2 : pyObject.asIterable()) {
                if (this.protocol == 0) {
                    this.save(pyObject2);
                    this.file.write('a');
                    continue;
                }
                if (n == 0) {
                    this.file.write('(');
                }
                this.save(pyObject2);
                if (++n != 1024) continue;
                this.file.write('e');
                n = 0;
            }
            if (n > 0) {
                this.file.write('e');
            }
        }

        private void save_dict(PyObject pyObject) {
            if (this.protocol > 0) {
                this.file.write('}');
            } else {
                this.file.write('(');
                this.file.write('d');
            }
            this.put(this.putMemo(Pickler.get_id(pyObject), pyObject));
            this.batch_setitems(pyObject.invoke("iteritems"));
        }

        private void batch_setitems(PyObject pyObject) {
            if (this.protocol == 0) {
                for (PyObject pyObject2 : pyObject.asIterable()) {
                    if (!(pyObject2 instanceof PyTuple) || pyObject2.__len__() != 2) {
                        throw Py.TypeError("dict items iterator must return 2-tuples");
                    }
                    this.save(pyObject2.__getitem__(0));
                    this.save(pyObject2.__getitem__(1));
                    this.file.write('s');
                }
            } else {
                int n;
                PyObject[] pyObjectArray = new PyObject[1024];
                do {
                    PyObject pyObject3;
                    for (n = 0; n < 1024 && (pyObject3 = pyObject.__iternext__()) != null; ++n) {
                        pyObjectArray[n] = pyObject3;
                    }
                    if (n > 1) {
                        this.file.write('(');
                        for (int i = 0; i < n; ++i) {
                            pyObject3 = pyObjectArray[i];
                            this.save(pyObject3.__getitem__(0));
                            this.save(pyObject3.__getitem__(1));
                        }
                        this.file.write('u');
                        continue;
                    }
                    if (n != 1) continue;
                    pyObject3 = pyObjectArray[0];
                    this.save(pyObject3.__getitem__(0));
                    this.save(pyObject3.__getitem__(1));
                    this.file.write('s');
                } while (n == 1024);
            }
        }

        private final void save_inst(PyInstance pyInstance) {
            int n;
            PyClass pyClass = pyInstance.instclass;
            PySequence pySequence = null;
            PyObject pyObject = pyInstance.__findattr__("__getinitargs__");
            if (pyObject != null) {
                pySequence = (PySequence)pyObject.__call__();
                this.keep_alive(pySequence);
            }
            this.file.write('(');
            if (this.protocol > 0) {
                this.save(pyClass);
            }
            if (pySequence != null) {
                n = pySequence.__len__();
                for (int i = 0; i < n; ++i) {
                    this.save(pySequence.__finditem__(i));
                }
            }
            n = this.putMemo(Pickler.get_id(pyInstance), pyInstance);
            if (this.protocol > 0) {
                this.file.write('o');
                this.put(n);
            } else {
                this.file.write('i');
                this.file.write(pyClass.__findattr__("__module__").toString());
                this.file.write("\n");
                this.file.write(pyClass.__name__);
                this.file.write("\n");
                this.put(n);
            }
            PyObject pyObject2 = null;
            PyObject pyObject3 = pyInstance.__findattr__("__getstate__");
            if (pyObject3 == null) {
                pyObject2 = pyInstance.__dict__;
            } else {
                pyObject2 = pyObject3.__call__();
                this.keep_alive(pyObject2);
            }
            this.save(pyObject2);
            this.file.write('b');
        }

        private final void save_global(PyObject pyObject) {
            this.save_global(pyObject, null);
        }

        private final void save_global(PyObject pyObject, PyObject pyObject2) {
            PyObject pyObject3;
            if (pyObject2 == null) {
                pyObject2 = pyObject.__findattr__("__name__");
            }
            if ((pyObject3 = pyObject.__findattr__("__module__")) == null || pyObject3 == Py.None) {
                pyObject3 = cPickle.whichmodule(pyObject, pyObject2);
            }
            if (this.protocol >= 2) {
                PyTuple pyTuple = new PyTuple(pyObject3, pyObject2);
                PyObject pyObject4 = extension_registry.get(pyTuple);
                if (pyObject4 != Py.None) {
                    int n = ((PyInteger)pyObject4).getValue();
                    if (n <= 255) {
                        this.file.write('\u0082');
                        this.file.write((char)n);
                    } else if (n <= 65535) {
                        this.file.write('\u0083');
                        this.file.write((char)(n & 0xFF));
                        this.file.write((char)(n >> 8));
                    } else {
                        this.file.write('\u0084');
                        this.writeInt4(n);
                    }
                    return;
                }
            }
            this.file.write('c');
            this.file.write(pyObject3.toString());
            this.file.write("\n");
            this.file.write(pyObject2.toString());
            this.file.write("\n");
            this.put(this.putMemo(Pickler.get_id(pyObject), pyObject));
        }

        private final int getMemoPosition(int n, Object object) {
            return this.memo.findPosition(n, object);
        }

        private final int putMemo(int n, PyObject pyObject) {
            int n2 = this.memo.size() + 1;
            this.memo.put(n, n2, pyObject);
            return n2;
        }

        private final void keep_alive(PyObject pyObject) {
            int n = System.identityHashCode(this.memo);
            PyList pyList = (PyList)this.memo.findValue(n, this.memo);
            if (pyList == null) {
                pyList = new PyList();
                this.memo.put(n, -1, pyList);
            }
            pyList.append(pyObject);
        }
    }

    public static class Unpickler {
        private PyIOFile file;
        public Map<String, PyObject> memo = Generic.map();
        public PyObject persistent_load = null;
        public PyObject find_global = null;
        private PyObject mark = new PyString("spam");
        private int stackTop;
        private PyObject[] stack;

        Unpickler(PyObject pyObject) {
            this.file = PyIOFileFactory.createIOFile(pyObject);
        }

        public PyObject load() {
            char c;
            this.stackTop = 0;
            this.stack = new PyObject[10];
            block55: while (true) {
                String string;
                if ((string = this.file.read(1)).length() < 1) {
                    this.load_eof();
                }
                c = string.charAt(0);
                switch (c) {
                    case 'P': {
                        this.load_persid();
                        continue block55;
                    }
                    case 'Q': {
                        this.load_binpersid();
                        continue block55;
                    }
                    case 'N': {
                        this.load_none();
                        continue block55;
                    }
                    case 'I': {
                        this.load_int();
                        continue block55;
                    }
                    case 'J': {
                        this.load_binint();
                        continue block55;
                    }
                    case 'K': {
                        this.load_binint1();
                        continue block55;
                    }
                    case 'M': {
                        this.load_binint2();
                        continue block55;
                    }
                    case 'L': {
                        this.load_long();
                        continue block55;
                    }
                    case 'F': {
                        this.load_float();
                        continue block55;
                    }
                    case 'G': {
                        this.load_binfloat();
                        continue block55;
                    }
                    case 'S': {
                        this.load_string();
                        continue block55;
                    }
                    case 'T': {
                        this.load_binstring();
                        continue block55;
                    }
                    case 'U': {
                        this.load_short_binstring();
                        continue block55;
                    }
                    case 'V': {
                        this.load_unicode();
                        continue block55;
                    }
                    case 'X': {
                        this.load_binunicode();
                        continue block55;
                    }
                    case 't': {
                        this.load_tuple();
                        continue block55;
                    }
                    case ')': {
                        this.load_empty_tuple();
                        continue block55;
                    }
                    case ']': {
                        this.load_empty_list();
                        continue block55;
                    }
                    case '}': {
                        this.load_empty_dictionary();
                        continue block55;
                    }
                    case 'l': {
                        this.load_list();
                        continue block55;
                    }
                    case 'd': {
                        this.load_dict();
                        continue block55;
                    }
                    case 'i': {
                        this.load_inst();
                        continue block55;
                    }
                    case 'o': {
                        this.load_obj();
                        continue block55;
                    }
                    case 'c': {
                        this.load_global();
                        continue block55;
                    }
                    case 'R': {
                        this.load_reduce();
                        continue block55;
                    }
                    case '0': {
                        this.load_pop();
                        continue block55;
                    }
                    case '1': {
                        this.load_pop_mark();
                        continue block55;
                    }
                    case '2': {
                        this.load_dup();
                        continue block55;
                    }
                    case 'g': {
                        this.load_get();
                        continue block55;
                    }
                    case 'h': {
                        this.load_binget();
                        continue block55;
                    }
                    case 'j': {
                        this.load_long_binget();
                        continue block55;
                    }
                    case 'p': {
                        this.load_put();
                        continue block55;
                    }
                    case 'q': {
                        this.load_binput();
                        continue block55;
                    }
                    case 'r': {
                        this.load_long_binput();
                        continue block55;
                    }
                    case 'a': {
                        this.load_append();
                        continue block55;
                    }
                    case 'e': {
                        this.load_appends();
                        continue block55;
                    }
                    case 's': {
                        this.load_setitem();
                        continue block55;
                    }
                    case 'u': {
                        this.load_setitems();
                        continue block55;
                    }
                    case 'b': {
                        this.load_build();
                        continue block55;
                    }
                    case '(': {
                        this.load_mark();
                        continue block55;
                    }
                    case '\u0080': {
                        this.load_proto();
                        continue block55;
                    }
                    case '\u0081': {
                        this.load_newobj();
                        continue block55;
                    }
                    case '\u0082': {
                        this.load_ext(1);
                        continue block55;
                    }
                    case '\u0083': {
                        this.load_ext(2);
                        continue block55;
                    }
                    case '\u0084': {
                        this.load_ext(4);
                        continue block55;
                    }
                    case '\u0085': {
                        this.load_small_tuple(1);
                        continue block55;
                    }
                    case '\u0086': {
                        this.load_small_tuple(2);
                        continue block55;
                    }
                    case '\u0087': {
                        this.load_small_tuple(3);
                        continue block55;
                    }
                    case '\u0088': {
                        this.load_boolean(true);
                        continue block55;
                    }
                    case '\u0089': {
                        this.load_boolean(false);
                        continue block55;
                    }
                    case '\u008a': {
                        this.load_bin_long(1);
                        continue block55;
                    }
                    case '\u008b': {
                        this.load_bin_long(4);
                        continue block55;
                    }
                    case '.': {
                        return this.load_stop();
                    }
                }
                break;
            }
            throw new PyException(UnpicklingError, String.format("invalid load key, '%s'.", Character.valueOf(c)));
        }

        private final int marker() {
            for (int i = this.stackTop - 1; i >= 0; --i) {
                if (this.stack[i] != this.mark) continue;
                return this.stackTop - i - 1;
            }
            throw new PyException(UnpicklingError, "Inputstream corrupt, marker not found");
        }

        private final void load_eof() {
            throw new PyException(Py.EOFError);
        }

        private void load_proto() {
            char c = this.file.read(1).charAt(0);
            if (c < '\u0000' || c > '\u0002') {
                throw Py.ValueError("unsupported pickle protocol: " + c);
            }
        }

        private final void load_persid() {
            this.load_persid(new PyString(this.file.readlineNoNl()));
        }

        private final void load_binpersid() {
            this.load_persid(this.pop());
        }

        private final void load_persid(PyObject pyObject) {
            if (this.persistent_load == null) {
                throw new PyException(UnpicklingError, "A load persistent id instruction was encountered,\nbut no persistent_load function was specified.");
            }
            if (this.persistent_load instanceof PyList) {
                ((PyList)this.persistent_load).append(pyObject);
            } else {
                pyObject = this.persistent_load.__call__(pyObject);
            }
            this.push(pyObject);
        }

        private final void load_none() {
            this.push(Py.None);
        }

        private final void load_int() {
            PyObject pyObject;
            String string = this.file.readlineNoNl();
            if (string.equals("01")) {
                pyObject = Py.True;
            } else if (string.equals("00")) {
                pyObject = Py.False;
            } else {
                try {
                    pyObject = Py.newInteger(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        pyObject = Py.newLong(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw Py.ValueError("could not convert string to int");
                    }
                }
            }
            this.push(pyObject);
        }

        private void load_boolean(boolean bl) {
            this.push(bl ? Py.True : Py.False);
        }

        private final void load_binint() {
            int n = this.read_binint();
            this.push(new PyInteger(n));
        }

        private int read_binint() {
            String string = this.file.read(4);
            return string.charAt(0) | string.charAt(1) << 8 | string.charAt(2) << 16 | string.charAt(3) << 24;
        }

        private final void load_binint1() {
            char c = this.file.read(1).charAt(0);
            this.push(new PyInteger(c));
        }

        private final void load_binint2() {
            int n = this.read_binint2();
            this.push(new PyInteger(n));
        }

        private int read_binint2() {
            String string = this.file.read(2);
            return string.charAt(1) << 8 | string.charAt(0);
        }

        private final void load_long() {
            String string = this.file.readlineNoNl();
            this.push(new PyLong(string.substring(0, string.length() - 1)));
        }

        private void load_bin_long(int n) {
            int n2 = this.read_binint(n);
            if (n2 == 0) {
                this.push(new PyLong(BigInteger.ZERO));
                return;
            }
            String string = this.file.read(n2);
            byte[] byArray = new byte[string.length()];
            int n3 = string.length() - 1;
            int n4 = 0;
            while (n4 < string.length()) {
                char c = string.charAt(n4);
                byArray[n3] = c >= '\u0080' ? (byte)(c - 256) : (byte)c;
                ++n4;
                --n3;
            }
            BigInteger bigInteger = new BigInteger(byArray);
            this.push(new PyLong(bigInteger));
        }

        private int read_binint(int n) {
            if (n == 1) {
                return this.file.read(1).charAt(0);
            }
            if (n == 2) {
                return this.read_binint2();
            }
            return this.read_binint();
        }

        private final void load_float() {
            String string = this.file.readlineNoNl();
            this.push(new PyFloat(Double.valueOf(string)));
        }

        private final void load_binfloat() {
            String string = this.file.read(8);
            long l = (long)string.charAt(7) | (long)string.charAt(6) << 8 | (long)string.charAt(5) << 16 | (long)string.charAt(4) << 24 | (long)string.charAt(3) << 32 | (long)string.charAt(2) << 40 | (long)string.charAt(1) << 48 | (long)string.charAt(0) << 56;
            this.push(new PyFloat(Double.longBitsToDouble(l)));
        }

        private final void load_string() {
            int n;
            String string = this.file.readlineNoNl();
            char c = string.charAt(0);
            if (c != '\"' && c != '\'') {
                throw Py.ValueError("insecure string pickle");
            }
            int n2 = 0;
            char c2 = '\u0000';
            int n3 = string.length();
            for (n = 1; n < n3 && ((c2 = string.charAt(n)) != c || n2 % 2 != 0); ++n) {
                if (c2 == '\\') {
                    ++n2;
                    continue;
                }
                n2 = 0;
            }
            if (c2 != c) {
                throw Py.ValueError("insecure string pickle");
            }
            ++n;
            while (n < string.length()) {
                if (string.charAt(n) > ' ') {
                    throw Py.ValueError("insecure string pickle " + n);
                }
                ++n;
            }
            String string2 = PyString.decode_UnicodeEscape(string, 1, n3 - 1, "strict", false);
            this.push(new PyString(string2));
        }

        private final void load_binstring() {
            int n = this.read_binint();
            this.push(new PyString(this.file.read(n)));
        }

        private final void load_short_binstring() {
            char c = this.file.read(1).charAt(0);
            this.push(new PyString(this.file.read(c)));
        }

        private final void load_unicode() {
            String string = this.file.readlineNoNl();
            String string2 = codecs.PyUnicode_DecodeRawUnicodeEscape(string, "strict");
            this.push(new PyUnicode(string2));
        }

        private final void load_binunicode() {
            int n = this.read_binint();
            String string = this.file.read(n);
            this.push(new PyUnicode(codecs.PyUnicode_DecodeUTF8(string, "strict")));
        }

        private final void load_tuple() {
            PyObject[] pyObjectArray = new PyObject[this.marker()];
            this.pop(pyObjectArray);
            this.pop();
            this.push(new PyTuple(pyObjectArray));
        }

        private final void load_empty_tuple() {
            this.push(new PyTuple(Py.EmptyObjects));
        }

        private void load_small_tuple(int n) {
            PyObject[] pyObjectArray = new PyObject[n];
            for (int i = n - 1; i >= 0; --i) {
                pyObjectArray[i] = this.pop();
            }
            this.push(new PyTuple(pyObjectArray));
        }

        private final void load_empty_list() {
            this.push(new PyList(Py.EmptyObjects));
        }

        private final void load_empty_dictionary() {
            this.push(new PyDictionary());
        }

        private final void load_list() {
            PyObject[] pyObjectArray = new PyObject[this.marker()];
            this.pop(pyObjectArray);
            this.pop();
            this.push(new PyList(pyObjectArray));
        }

        private final void load_dict() {
            int n = this.marker();
            PyDictionary pyDictionary = new PyDictionary();
            for (int i = 0; i < n; i += 2) {
                PyObject pyObject = this.pop();
                PyObject pyObject2 = this.pop();
                pyDictionary.__setitem__(pyObject2, pyObject);
            }
            this.pop();
            this.push(pyDictionary);
        }

        private final void load_inst() {
            PyObject[] pyObjectArray = new PyObject[this.marker()];
            this.pop(pyObjectArray);
            this.pop();
            String string = this.file.readlineNoNl();
            String string2 = this.file.readlineNoNl();
            PyObject pyObject = this.find_class(string, string2);
            PyObject pyObject2 = null;
            pyObject2 = pyObjectArray.length == 0 && pyObject instanceof PyClass && pyObject.__findattr__("__getinitargs__") == null ? new PyInstance((PyClass)pyObject) : pyObject.__call__(pyObjectArray);
            this.push(pyObject2);
        }

        private final void load_obj() {
            PyObject[] pyObjectArray = new PyObject[this.marker() - 1];
            this.pop(pyObjectArray);
            PyObject pyObject = this.pop();
            this.pop();
            PyObject pyObject2 = null;
            pyObject2 = pyObjectArray.length == 0 && pyObject instanceof PyClass && pyObject.__findattr__("__getinitargs__") == null ? new PyInstance((PyClass)pyObject) : pyObject.__call__(pyObjectArray);
            this.push(pyObject2);
        }

        private final void load_global() {
            String string = this.file.readlineNoNl();
            String string2 = this.file.readlineNoNl();
            PyObject pyObject = this.find_class(string, string2);
            this.push(pyObject);
        }

        private final PyObject find_class(String string, String string2) {
            PyObject pyObject;
            if (this.find_global != null) {
                if (this.find_global == Py.None) {
                    throw new PyException(UnpicklingError, "Global and instance pickles are not supported.");
                }
                return this.find_global.__call__(new PyString(string), (PyObject)new PyString(string2));
            }
            PyObject pyObject2 = Py.getSystemState().modules;
            PyObject pyObject3 = pyObject2.__finditem__(string.intern());
            if (pyObject3 == null) {
                pyObject3 = cPickle.importModule(string);
            }
            if ((pyObject = pyObject3.__findattr__(string2.intern())) == null) {
                throw new PyException(Py.SystemError, "Failed to import class " + string2 + " from module " + string);
            }
            return pyObject;
        }

        private void load_ext(int n) {
            int n2 = this.read_binint(n);
            PyObject pyObject = inverted_registry.get(Py.newInteger(n2));
            if (pyObject == null) {
                throw new PyException(Py.ValueError, "unregistered extension code " + n2);
            }
            String string = pyObject.__finditem__(0).toString();
            String string2 = pyObject.__finditem__(1).toString();
            this.push(this.find_class(string, string2));
        }

        private final void load_reduce() {
            PyObject pyObject = this.pop();
            PyObject pyObject2 = this.pop();
            PyObject pyObject3 = null;
            pyObject3 = pyObject == Py.None ? pyObject2.__findattr__("__basicnew__").__call__() : pyObject2.__call__(this.make_array(pyObject));
            this.push(pyObject3);
        }

        private void load_newobj() {
            PyObject pyObject = this.pop();
            PyObject pyObject2 = this.pop();
            PyObject[] pyObjectArray = new PyObject[pyObject.__len__() + 1];
            pyObjectArray[0] = pyObject2;
            for (int i = 1; i < pyObjectArray.length; ++i) {
                pyObjectArray[i] = pyObject.__finditem__(i - 1);
            }
            this.push(pyObject2.__getattr__("__new__").__call__(pyObjectArray));
        }

        private final PyObject[] make_array(PyObject pyObject) {
            int n = pyObject.__len__();
            PyObject[] pyObjectArray = new PyObject[n];
            for (int i = 0; i < n; ++i) {
                pyObjectArray[i] = pyObject.__finditem__(i);
            }
            return pyObjectArray;
        }

        private final void load_pop() {
            this.pop();
        }

        private final void load_pop_mark() {
            this.pop(this.marker());
        }

        private final void load_dup() {
            this.push(this.peek());
        }

        private final void load_get() {
            String string = this.file.readlineNoNl();
            PyObject pyObject = this.memo.get(string);
            if (pyObject == null) {
                throw new PyException(BadPickleGet, string);
            }
            this.push(pyObject);
        }

        private final void load_binget() {
            String string = String.valueOf((int)this.file.read(1).charAt(0));
            PyObject pyObject = this.memo.get(string);
            if (pyObject == null) {
                throw new PyException(BadPickleGet, string);
            }
            this.push(pyObject);
        }

        private final void load_long_binget() {
            int n = this.read_binint();
            String string = String.valueOf(n);
            PyObject pyObject = this.memo.get(string);
            if (pyObject == null) {
                throw new PyException(BadPickleGet, string);
            }
            this.push(pyObject);
        }

        private final void load_put() {
            this.memo.put(this.file.readlineNoNl(), this.peek());
        }

        private final void load_binput() {
            char c = this.file.read(1).charAt(0);
            this.memo.put(String.valueOf((int)c), this.peek());
        }

        private final void load_long_binput() {
            int n = this.read_binint();
            this.memo.put(String.valueOf(n), this.peek());
        }

        private final void load_append() {
            PyObject pyObject = this.pop();
            PyObject pyObject2 = this.peek();
            if (pyObject2 instanceof PyList) {
                ((PyList)pyObject2).append(pyObject);
            } else {
                PyObject pyObject3 = pyObject2.__getattr__("append");
                pyObject3.__call__(pyObject);
            }
        }

        private final void load_appends() {
            int n = this.marker();
            PyObject pyObject = this.peek(n + 1);
            if (pyObject instanceof PyList) {
                for (int i = n - 1; i >= 0; --i) {
                    ((PyList)pyObject).append(this.peek(i));
                }
            } else {
                PyObject pyObject2 = pyObject.__getattr__("append");
                for (int i = n - 1; i >= 0; --i) {
                    pyObject2.__call__(this.peek(i));
                }
            }
            this.pop(n + 1);
        }

        private final void load_setitem() {
            PyObject pyObject = this.pop();
            PyObject pyObject2 = this.pop();
            PyDictionary pyDictionary = (PyDictionary)this.peek();
            pyDictionary.__setitem__(pyObject2, pyObject);
        }

        private final void load_setitems() {
            int n = this.marker();
            PyDictionary pyDictionary = (PyDictionary)this.peek(n + 1);
            for (int i = 0; i < n; i += 2) {
                PyObject pyObject = this.peek(i + 1);
                PyObject pyObject2 = this.peek(i);
                pyDictionary.__setitem__(pyObject, pyObject2);
            }
            this.pop(n + 1);
        }

        private void load_build() {
            Object object;
            PyObject pyObject = this.pop();
            PyObject pyObject2 = this.peek();
            PyObject pyObject3 = pyObject2.__findattr__("__setstate__");
            if (pyObject3 != null) {
                pyObject3.__call__(pyObject);
                return;
            }
            PyObject pyObject4 = null;
            if (pyObject instanceof PyTuple && pyObject.__len__() == 2) {
                object = pyObject;
                pyObject = ((PyObject)object).__getitem__(0);
                pyObject4 = ((PyObject)object).__getitem__(1);
            }
            if (pyObject != Py.None) {
                if (!(pyObject instanceof PyDictionary)) {
                    throw new PyException(UnpicklingError, "state is not a dictionary");
                }
                object = pyObject2.__getattr__("__dict__");
                for (PyObject pyObject5 : ((PyDictionary)pyObject).iteritems().asIterable()) {
                    ((PyObject)object).__setitem__(pyObject5.__getitem__(0), pyObject5.__getitem__(1));
                }
            }
            if (pyObject4 != null) {
                if (!(pyObject4 instanceof PyDictionary)) {
                    throw new PyException(UnpicklingError, "slot state is not a dictionary");
                }
                for (PyObject pyObject6 : ((PyDictionary)pyObject4).iteritems().asIterable()) {
                    pyObject2.__setattr__(PyObject.asName(pyObject6.__getitem__(0)), pyObject6.__getitem__(1));
                }
            }
        }

        private final void load_mark() {
            this.push(this.mark);
        }

        private final PyObject load_stop() {
            return this.pop();
        }

        private final PyObject peek() {
            return this.stack[this.stackTop - 1];
        }

        private final PyObject peek(int n) {
            return this.stack[this.stackTop - n - 1];
        }

        private final PyObject pop() {
            PyObject pyObject = this.stack[--this.stackTop];
            this.stack[this.stackTop] = null;
            return pyObject;
        }

        private final void pop(int n) {
            for (int i = 0; i < n; ++i) {
                this.stack[--this.stackTop] = null;
            }
        }

        private final void pop(PyObject[] pyObjectArray) {
            int n = pyObjectArray.length;
            System.arraycopy(this.stack, this.stackTop - n, pyObjectArray, 0, n);
            this.stackTop -= n;
        }

        private final void push(PyObject pyObject) {
            if (this.stackTop >= this.stack.length) {
                PyObject[] pyObjectArray = new PyObject[(this.stackTop + 1) * 2];
                System.arraycopy(this.stack, 0, pyObjectArray, 0, this.stack.length);
                this.stack = pyObjectArray;
            }
            this.stack[this.stackTop++] = pyObject;
        }
    }
}

